#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//TwistorsMod01.fsh  by   psonice  
//https://www.shadertoy.com/view/MdS3R3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// comment out these lines if you need more speed:
#define SHADOWS
#define REFLECTIONS

#define R(p,a) p=cos(a)*p+sin(a)*vec2(-p.y,p.x);
const float PI = 3.141592653589793;
const float threshold = 0.001;
const float maxIters = 50.;
const float ambient = 0.2;
const float maxD = 100.;

vec3 lightPos = vec3(10.);

// materials
int m; // material index

float cube(vec4 cube, vec3 pos){
	cube.xyz -= pos;
	return max(max(abs(cube.x)-cube.w,abs(cube.y)-cube.w),abs(cube.z)-cube.w);
}

float df(vec3 p){
	p += vec3(
		sin(p.z * 1.55 + iTime) + sin(p.z * 1.34 + iTime),
		0.,
		sin(p.x * 1.34 + iTime) + sin(p.x * 1.55 + iTime)
	) * .5;
	vec3 mp = mod(p, 1.);
	mp.y = p.y;
	
	float s1 = cube(
		vec4(0.5, 0.5, 0.5, 0.15),
		vec3(mp.x, mp.y + (sin(p.z * PI) * sin(p.x * PI)) * 0.25, 0.5));
	float s2 = cube(
		vec4(0.5, 0.5, 0.5, 0.15), 
		vec3(0.5, mp.y + (sin(p.x * PI) * -sin(p.z * PI)) * 0.25, mp.z));
	m = s1 < s2 ? 0 : 1;
	return min(s1, s2);
}

vec2 rm(vec3 pos, vec3 dir, float threshold, float td){
	vec3 startPos = pos;
	vec3 oDir = dir;
	float l,i, tl;
	l = 0.;
	
	for(float i=0.; i<=1.; i+=1.0/maxIters){
		l = df(pos);
		if(abs(l) < threshold){
			break;
		}
		pos += (l * dir * 0.7);
	}
	l = length(startPos - pos);
	return vec2(l < td ? 1.0 : -1.0, min(l, td));
}

float softShadow(vec3 pos, vec3 l, float r, float f, float td) {
	float d;
	vec3 p;
	float o = 1.0, maxI = 10., or = r;
	float len;
	for (float i=10.; i>1.; i--) {
		len = (i - 1.) / maxI;
		p = pos + ((l - pos) * len);
		r = or * len;
		d = clamp(df(p), 0.0, 1.0);
		o -= d < r ? (r -d)/(r * f) : 0.;
		
		if(o < 0.) break;
	}
	return o;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec3 camPos = vec3(0., sin(iTime*.3)+3., iTime);
	vec3 uv = vec3(fragCoord.xy / iResolution.xy, 1.);
	vec3 rayDir = uv;
	rayDir = normalize(rayDir);
	rayDir.yz = R(rayDir.yz, sin(iTime*.25)*.25+1.25);
	rayDir.xz = R(rayDir.xz, sin(iTime*.2));
	
	float camDist = length(camPos);
	
	float gd = maxD;
	vec2 march = rm(camPos, rayDir, threshold, gd);
	
	int lm = m;
	vec3 point = camPos + (rayDir * march.g);
	vec2 e = vec2(0.01, 0.0);
	vec3 n = march.x == 1.0 ? 
		(vec3(df(point+e.xyy),df(point +e.yxy),df(point +e.yyx))-df(point))/e.x :
		vec3(0., 1., 0.);
	
	vec3 lightDir = normalize(lightPos);
	float intensity = max(dot(n, lightDir), 0.0) * 0.5;
	vec3 lightPos2 = point + lightDir;
	
#ifdef SHADOWS
	intensity *= 3.;
	intensity *= softShadow(point, point + n, 2.0, 8., gd); // AO
#endif
	
	intensity -= (march.y)*0.02;
	intensity = march.y == maxD ? 0. : intensity;
	vec4 p = vec4(1.0);
	vec3 c = clamp(lm == 0 ? vec3(sin(point)) * .25 : vec3(cos(point)), 0., 1.);
	
	c += 1.;
	p.rgb = march.x == -1. ? vec3(0.) : vec3(c * (intensity + ambient));
	
	fragColor = p;
#ifdef REFLECTIONS
	vec4 p2 = vec4(0.,0.,0.,1.);
	n = normalize(n);
	
	vec3 refDir = rayDir - 2. * dot(n,rayDir) * n;
		
	point += refDir * 0.01;
	march = rm(point, refDir, threshold, maxD);
	if(march.y < 0.5){
		point += (refDir * march.y);
		lm = m;
		n = (vec3(df(point+e.xyy),df(point +e.yxy),df(point +e.yyx))-df(point))/e.x;
		intensity = max(dot(n, lightDir), 0.0) * 0.5;
		c = clamp(lm == 0 ? vec3(sin(point)) * .25 : vec3(cos(point)), 0., 1.);
		c += 1.;
		p2.rgb = vec3(c * (intensity + ambient));
	}
	fragColor = mix(p, p2, 0.2);
#endif
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

